/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.FlamingoConfig;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.Ingredients;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class FlamingoEntity
extends Animal
implements ILexiconEntry {
    private static final EntityDataAccessor<Boolean> LEFT_LEG_UP = SynchedEntityData.m_135353_(FlamingoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RIGHT_LEG_UP = SynchedEntityData.m_135353_(FlamingoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected DeepWaterAvoidingRandomWalkingGoal randomWalkingGoal;

    public FlamingoEntity(EntityType<? extends FlamingoEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.WATER, 1.0f);
    }

    public static boolean checkFlamingoSpawnRules(EntityType<FlamingoEntity> animal, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(LivingThingsTags.FLAMINGO_SPAWNABLE_ON) && FlamingoEntity.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)ModEntityTypes.FLAMINGO.get().m_20615_((Level)world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, FlamingoConfig.health()).m_22268_(Attributes.f_22279_, FlamingoConfig.movementSpeed());
    }

    protected void m_8099_() {
        this.randomWalkingGoal = new DeepWaterAvoidingRandomWalkingGoal(this, 1.0, 50);
        this.f_21345_.m_25352_(0, (Goal)new SwimInDeepWaterGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredients.FLAMINGO_FOOD, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new LiftLegsGoal(this, 15));
        this.f_21345_.m_25352_(5, (Goal)this.randomWalkingGoal);
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, FlamingoEntity.class, 8.0f));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LEFT_LEG_UP, (Object)false);
        this.f_19804_.m_135372_(RIGHT_LEG_UP, (Object)false);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(LivingThingsTags.FLAMINGO_FOOD);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.99f;
    }

    protected float m_6108_() {
        return 0.98f;
    }

    public int m_5792_() {
        return FlamingoConfig.maxSpawnedInChunk();
    }

    public boolean isLeftLegUp() {
        return (Boolean)this.f_19804_.m_135370_(LEFT_LEG_UP);
    }

    public boolean isRightLegUp() {
        return (Boolean)this.f_19804_.m_135370_(RIGHT_LEG_UP);
    }

    public void setLeftLegUp(boolean up) {
        this.f_19804_.m_135381_(LEFT_LEG_UP, (Object)up);
    }

    public void setRightLegUp(boolean up) {
        this.f_19804_.m_135381_(RIGHT_LEG_UP, (Object)up);
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.FLAMINGO;
    }

    static class DeepWaterAvoidingRandomWalkingGoal
    extends RandomStrollGoal {
        private final FlamingoEntity flamingo;

        public DeepWaterAvoidingRandomWalkingGoal(FlamingoEntity creatureIn, double speedIn, int chance) {
            super((PathfinderMob)creatureIn, speedIn, chance);
            this.flamingo = creatureIn;
        }

        protected Vec3 m_7037_() {
            if (this.flamingo.f_19800_) {
                Vec3 vector3d = LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)15, (int)7);
                return vector3d == null ? super.m_7037_() : vector3d;
            }
            return LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)10, (int)7);
        }
    }

    static class SwimInDeepWaterGoal
    extends FloatGoal {
        private final FlamingoEntity flamingo;

        public SwimInDeepWaterGoal(FlamingoEntity entityIn) {
            super((Mob)entityIn);
            this.flamingo = entityIn;
        }

        public boolean m_8036_() {
            return this.flamingo.f_19800_ && super.m_8036_();
        }

        public void m_8037_() {
            this.flamingo.randomWalkingGoal.m_25751_();
            super.m_8037_();
        }
    }

    static class LiftLegsGoal
    extends Goal {
        private final FlamingoEntity flamingo;
        private final int chance;
        private int rightLegCounter;
        private int leftLegCounter;

        public LiftLegsGoal(FlamingoEntity flamingo, int chance) {
            this.flamingo = flamingo;
            this.chance = chance;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.flamingo.m_217043_().m_188503_(this.chance) != 0) {
                return false;
            }
            return !this.flamingo.isRightLegUp() && !this.flamingo.isLeftLegUp() && this.flamingo.m_21573_().m_26571_();
        }

        public boolean m_8045_() {
            return this.flamingo.m_21573_().m_26571_() && (this.flamingo.isRightLegUp() || this.flamingo.isLeftLegUp());
        }

        public void m_8041_() {
            this.leftLegCounter = 0;
            this.rightLegCounter = 0;
            this.flamingo.setLeftLegUp(false);
            this.flamingo.setRightLegUp(false);
        }

        public void m_8037_() {
            if (this.leftLegCounter > 0) {
                --this.leftLegCounter;
            } else if (this.leftLegCounter <= 0) {
                this.leftLegCounter = 0;
                this.flamingo.setLeftLegUp(false);
            }
            if (this.rightLegCounter > 0) {
                --this.rightLegCounter;
            } else if (this.rightLegCounter <= 0) {
                this.rightLegCounter = 0;
                this.flamingo.setRightLegUp(false);
            }
            if (this.rightLegCounter == 0 && this.leftLegCounter == 0 && Math.random() < (double)0.1f) {
                if (Math.random() < 0.5) {
                    this.leftLegCounter = 500;
                    this.flamingo.setLeftLegUp(true);
                } else {
                    this.rightLegCounter = 500;
                    this.flamingo.setRightLegUp(true);
                }
            }
        }
    }
}

